#ifndef RECT_HPP
#define RECT_HPP
#include "types.h" //for Windows RECT type
#include "random.h" //for Rect::Randompoint
#include "point4.hpp"

#define RECT_INSIDE 0
#define RECT_LEFT 1
#define RECT_RIGHT 2
#define RECT_TOP 4
#define RECT_BOTTOM 8

class Rect
{
private:
	int _left, _top, _bottom, _right;
	void _Arrange(); //helper function
public:
	Rect():_left(0),_top(0),_right(0),_bottom(0){}
	Rect(Point p, Point q);
	Rect(int px, int py, int qx, int qy);
	Rect(RECT r);
	Rect(HWND hwnd);
	~Rect(){}
	int left()const{return _left;}
	int right()const{return _right;}
	int top()const{return _top;}
	int bottom()const{return _bottom;}
	int Clamp(Point &p)const;
	int Wrap(Point &p)const;
};

#endif //RECT_HPP
